<?php

class FoxcommerceContent_AdminSection extends FoxcommerceAdminSection
{
    protected static $url_rule    = 'Content';
    protected static $menu_title  = 'Content Configuration';
    protected static $description = 'Manage the content for actions in your shop';

    protected static $allowed_actions = [
        'handleSave'
    ];

    public function updateCMSFields(FieldList $fields)
    {

        $config = FoxcommerceConfig::current();

        $fields->addFieldsToTab('Root.Checkout', [
            HtmlEditorField::create('CheckoutCompleteMessage', 'Checkout Complete Message'),
        ]);

        $fields->addFieldsToTab('Root.Emails.Admin', [
            EmailField::create('EmailForAdminAddress', 'Email Address'),
            TextField::create('EmailForAdminSubject', 'Subject of order complete email'),
            HtmlEditorField::create('EmailForAdminContent', 'Content of order complete email'),
        ]);

        $fields->addFieldsToTab('Root.Emails.Customer', [
            EmailField::create('FromEmailForCustomer', 'Email sent from address'),
            EmailField::create('ReplyToEmailForCustomer', 'Email address responses should get sent to'),
            TextField::create('EmailForCustomerSubject', 'Subject of order complete email'),
            HtmlEditorField::create('EmailForCustomerContent', 'Content of order complete email'),
        ]);
    }

    public function updateEditForm(CMSForm $form)
    {
        $form->loadDataFrom(FoxcommerceConfig::current());
    }


    public function updateCMSActions(FieldList $actions)
    {

        $actions->push(
            FormAction::create('handleSave', _t('GridFieldDetailForm.Save', 'Save'))
                ->setUseButtonTag(true)->addExtraClass('ss-ui-action-constructive'));
        return $actions;
    }

    public function handleSave($data, Form $form)
    {
        $config = FoxcommerceConfig::current();
        $form->saveInto($config);
        $config->write();

        $form->sessionMessage('Shop content updated', 'good');
    }

}