<?php

/**
 * Class FoxcommerceConfiguration_AdminSection
 *
 * @mixin FoxcommerceConfiguration_AdminSection_TaxExtension
 */
class FoxcommerceConfiguration_AdminSection extends FoxcommerceAdminSection
{
    protected static $url_rule    = 'Configuration';
    protected static $menu_title  = 'Basic Configuration';
    protected static $description = 'Manage the basic config for your shop';

    protected static $allowed_actions = [
        'handleSave'
    ];

    public function updateCMSFields(FieldList $fields)
    {
        $countries = FoxcommerceCountry::get()->map()->toArray();

        $fields->addFieldToTab('Root.Main',
            DropdownField::create('FallbackCountryID', 'Fallback country', $countries)
        );
    }

    public function updateEditForm(CMSForm $form){
        $form->loadDataFrom(FoxcommerceConfig::current());
    }


    public function updateCMSActions(FieldList $actions)
    {
        $actions->push(
            FormAction::create('handleSave', _t('GridFieldDetailForm.Save', 'Save'))
                ->setUseButtonTag(true)->addExtraClass('ss-ui-action-constructive'));
    }

    public function handleSave($data, Form $form)
    {
        $config = FoxcommerceConfig::current();
        $form->saveInto($config);
        $config->write();
        $form->sessionMessage('Shop basic configuration updated', 'good');
    }

}