<?php

class GridFieldDuplicateButton implements GridField_ColumnProvider, GridField_ActionProvider
{
    public function augmentColumns($gridField, &$columns)
    {
        if (!in_array('Actions', $columns)) {
            $columns[] = 'Actions';
        }
    }

    public function getColumnAttributes($gridField, $record, $columnName)
    {
        return array('class' => 'col-buttons');
    }

    public function getColumnMetadata($gridField, $columnName)
    {
        if ($columnName == 'Actions') {
            return array('title' => '');
        }
    }

    public function getColumnsHandled($gridField)
    {
        return array('Actions');
    }

    public function getActions($gridField)
    {
        return array('duplicate');
    }

    public function getColumnContent($gridField, $record, $columnName)
    {
        if (!$record->canCreate()) {
            return;
        }

        /** @var GridField_FormAction $field */
        $field = GridField_FormAction::create($gridField, 'Duplicate' . $record->ID, false, "duplicate",
            array('RecordID' => $record->ID))
            ->addExtraClass('gridfield-button-duplicate')
            ->setAttribute('title', _t('GridAction.Duplicate', "Duplicate"))
            ->setDescription(_t('GridAction.COPY_DESCRIPTION', 'Duplicate'));
        return $field->Field();
    }

    public function handleAction(GridField $gridField, $actionName, $arguments, $data)
    {
        if ($actionName == 'duplicate') {
            /** @var DataObject $item */
            $item = $gridField->getList()->byID($arguments['RecordID']);
            if (!$item) {
                return;
            }
            if (!$item->canCreate()) {
                throw new ValidationException("Permission to create object is denied");
            }
            $clone = $item->duplicate();
            if (!$clone || $clone->ID < 1) {
                user_error("Error Duplicating!", E_USER_ERROR);
            }

            $response = Controller::curr()->getResponse();
            $response->addHeader('X-Reload', true);
            $response->addHeader('X-ControllerURL',
                Controller::join_links($gridField->Link('item'), $clone->ID, 'edit')
            );
            return $response;

        }
    }
}