<?php

/**
 * Class FoxcommerceAdminSection
 *
 */
class FoxcommerceAdminSection extends LeftAndMain
{

    protected static $url_segment = 'ecommerce';

    protected static $menu_title = 'Shop';

    protected static $tree_class = 'FoxcommerceConfig';

    protected static $menu_icon = 'foxcommerce/images/basket-icon.png';

    protected static $is_subsection = false;

    protected static $allowed_actions = [
        'EditForm',
        'Section',
        'handleSubmit'
    ];

    /** @var FoxcommerceAdminSection */
    protected $activeSubSection = null;

    public function getActiveSubSection($section = null)
    {
        if ($this->activeSubSection && !$section) return $this->activeSubSection;

        $action = ($section ? $section : $this->request->param('ID'));
        if (!$action) return;

        $subClasses     = array_diff(ClassInfo::subclassesFor('FoxcommerceAdminSection'), ['FoxcommerceAdminSection']);
        $activeSubclass = null;

        foreach ($subClasses as $subClass) {
            $urlSection = Config::inst()->get($subClass, 'url_rule');
            if (strtolower($action) === strtolower($urlSection)) {
                $this->activeSubSection = singleton($subClass);
                break;
            }
        }

        return $this->activeSubSection;
    }

    public function init()
    {
        parent::init();
        Requirements::css(FOXCOMMERCE_DIR . '/css/foxcommerceAdmin.css');
        $this->getActiveSubSection($this->request->requestVar('SubSection'));

    }

    public function Section(SS_HTTPRequest $request)
    {
        $action = $request->param('ID');
        Session::set(__CLASS__ . '.SubSection', $action);
        $this->getActiveSubSection($action);

        if (!$this->activeSubSection) {
            $this->httpError('404', "Section '{$action}' not found");
        }

        if ($request->param('OtherID') === 'EditForm') {
            return $this->EditForm($request);
        }

        return $this->index($request, $action);
    }

    public function index($request, $section = null)
    {
        if (!$section) {
            Session::clear(__CLASS__ . '.SubSection');
        }
        return parent::index($request);
    }

    public function Breadcrumbs($unlinked = false)
    {

        $list = ArrayList::create([
            ArrayData::create([
                'Title' => Config::inst()->get('FoxcommerceAdminSection', 'menu_title'),
                'Link'  => $this->Link()
            ])
        ]);

        if ($this->activeSubSection) {
            $list->push(ArrayData::create([
                'Title' => $this->activeSubSection->config()->menu_title,
                'Link'  => $this->Link('Section' . '/' . $this->activeSubSection->config()->url_rule)
            ]));
        }
        return $list;

    }

    public function EditForm($request = null)
    {
        if ($request && $request->param('Action') === 'EditForm') {
            $this->getActiveSubSection(Session::get(__CLASS__ . '.SubSection'));
        }
        return parent::EditForm($request);
    }


    public function getFieldsBase()
    {
        $fields = FieldList::create([
            $rootTabSet = new TabSet("Root")
        ]);

        if ($this->activeSubSection) {
            $fields->push(HiddenField::create('SubSection', null, $this->activeSubSection->config()->get('url_rule')));
        }

        $rootTabSet->setTemplate('CMSTabSet');

        return $fields;
    }

    public function getEditForm($id = null, $fields = null)
    {

        $fields    = $this->getFieldsBase();
        $actions   = FieldList::create();
        $validator = null;

        if (!$this->activeSubSection) {
            $this->addProductsFields($fields);
            $this->addPaidOrdersFields($fields);
            $this->addUnpaidOrdersFields($fields);
            $this->addConfigFields($fields);
            $this->extend('updateCMSFields', $fields);

            $form = $this->buildForm($fields, $actions, $validator);
        } else {
            if ($this->activeSubSection->hasMethod('updateCMSFields')) {
                $this->activeSubSection->updateCMSFields($fields);
            }
            if ($this->activeSubSection->hasMethod('updateCMSActions')) {
                $this->activeSubSection->updateCMSActions($actions);
            }
            if ($this->activeSubSection->hasMethod('updateCMSValidator')) {
                $this->activeSubSection->updateCMSValidator($validator);
            }
            $this->activeSubSection->extend('updateCMSFields', $fields);
            $this->activeSubSection->extend('updateCMSActions', $actions);

            $form = $this->buildForm($fields, $actions, $validator);

            if ($this->activeSubSection->hasMethod('updateEditForm')) {
                $this->activeSubSection->updateEditForm($form);
            }
            $this->activeSubSection->extend('updateEditForm', $form);
        }

        return $form;
    }

    protected function addProductsFields(FieldList $fields)
    {
        $productsConfig = GridFieldConfig_Lumberjack::create();
        $productsField  = GridField::create('FoxcommerceProduct', 'All Products', FoxcommerceProduct::get(), $productsConfig);
        $fields->addFieldToTab('Root.Products', $productsField);
    }

    protected function formatMoney(FoxcommerceOrder $order, $amount)
    {
        $oldLocale      = setlocale(LC_MONETARY, $order->current()->Country()->LocaleCode);
        $formattedPrice = money_format('%.2n', $amount);
        setlocale(LC_MONETARY, $oldLocale);
        return $formattedPrice;
    }

    public function orderConfig(){
        $config = GridFieldConfig_RecordEditor::create(300);
        $config->removeComponentsByType('GridFieldAddNewButton');
        $config->addComponent($exportButton = new GridFieldExportButton('buttons-before-left'));

//        /** @var GridFieldDataColumns $dataColumns */
//        $dataColumns = $config->getComponentByType('GridFieldDataColumns');
//        $dataColumns->setFieldFormatting([
//            'Total'        => function ($amount, FoxcommerceOrder $order) {
//                return $this->formatMoney($order, $amount);
//            },
//            'TotalPaid'    => function ($amount, FoxcommerceOrder $order) {
//                return $this->formatMoney($order, $amount);
//            },
//            'ItemQuantity' => function ($items, FoxcommerceOrder $order) {
//                return ceil($items);
//            }
//        ]);

        return $config;
    }

    protected function addPaidOrdersFields(FieldList $fields)
    {
        $paidOrders      = FoxcommerceOrder::get()
            ->filter(['Payments.ID:GreaterThan' => 0])
            ->where(['Payment.Status' => 'Captured']);
        $paidOrdersField = GridField::create('FoxcommerceOrdersPaid', 'Paid Orders', $paidOrders, $this->orderConfig());
        $fields->addFieldToTab('Root.Orders/Sales.Paid', $paidOrdersField);
    }

    protected function addUnpaidOrdersFields(FieldList $fields)
    {
        $unpaidOrders = FoxcommerceOrder::get()
            ->leftJoin('Payment', "Payment.FoxcommerceOrderID = FoxcommerceOrder.ID AND Payment.Status = 'Captured'")
            ->where('Payment.ID IS NULL');
        $unpaidOrdersField  = GridField::create('FoxcommerceOrdersUnpaid', 'Unpaid Orders', $unpaidOrders, $this->orderConfig());
        $fields->addFieldToTab('Root.Orders/Sales.Unpaid', $unpaidOrdersField);
    }

    protected function addConfigFields(FieldList $fields)
    {
        $fields->addFieldToTab('Root.Settings', LiteralField::create('ConfigSections', SSViewer::execute_template(
            'FoxcommerceAdminSection_AdminPanels', ArrayData::create(['Sections' => $this->Sections()])
        )));
    }

    protected function buildForm(FieldList $fields, FieldList $actions, Validator $validator = null)
    {
        $form = FoxcommerceAdminCMSForm::create($this, 'EditForm', $fields, $actions, $validator)
            ->setHTMLID('Form_EditForm');

        $form->setResponseNegotiator($this->getResponseNegotiator());
        $form->addExtraClass('cms-edit-form');
        $form->setTemplate($this->getTemplatesWithSuffix('_EditForm'));
        // Tab nav in CMS is rendered through separate template
        if ($form->Fields()->hasTabset()) {
            $form->Fields()->findOrMakeTab('Root')->setTemplate('CMSTabSet');
        }
        $form->addExtraClass('center ss-tabset cms-tabset ' . $this->BaseCSSClasses());
        $form->setAttribute('data-pjax-fragment', 'CurrentForm');
        if ($this->activeSubSection) {
            $form->setRealHandler($this->activeSubSection);
        }

        return $form;
    }

    public function Sections()
    {
        $subClasses = array_diff(ClassInfo::subclassesFor('FoxcommerceAdminSection'), ['FoxcommerceAdminSection']);

        /** @var ArrayList $list */
        $list = ArrayList::create();
        foreach ($subClasses as $subClass) {
            /** @var FoxcommerceAdminSection $inst */
            $inst = singleton($subClass);
            $list->push([
                'Title'       => $inst->stat('menu_title'),
                'Description' => $inst->stat('description'),
                'Link'        => $this->Link('Section' . '/' . $inst->stat('url_rule'))
            ]);

        }
        $list = $list->sort('Title ASC');

        return $list;
    }

    public function handleSubmit($data, CMSForm $form, $request, $funcName)
    {
        $this->activeSubSection->extend('onBeforeSave', $data, $form, $request);
        $this->activeSubSection->{$funcName}($data, $form, $request);
        $this->activeSubSection->extend('onAfterSave', $data, $form, $request);
        return $this->redirectBack();
    }
}
