<?php

/**
 * Class FoxcommerceAdminCMSForm
 *
 * @property FoxcommerceAdminSection $controller
 */
class FoxcommerceAdminCMSForm extends CMSForm
{

    private static $allowed_actions = [
        'handleField',
        'httpSubmission',
        'forTemplate',
    ];

    /**
     * @var array
     */
    private static $url_handlers = array(
        'field/$FieldName!'                   => 'handleField',
        'POST '                               => 'httpSubmission',
        'GET '                                => 'httpSubmission',
        'HEAD '                               => 'httpSubmission',
    );

    /** @var  FoxcommerceAdminSection */
    protected $realHandler;

    public function setRealHandler($handler)
    {
        $this->realHandler = $handler;
    }

    /**
     * Handle a form submission.  GET and POST requests behave identically.
     * Populates the form with {@link loadDataFrom()}, calls {@link validate()},
     * and only triggers the requested form action/method
     * if the form is valid.
     *
     * @param SS_HTTPRequest $request
     * @throws SS_HTTPResponse_Exception
     */
    public function httpSubmission($request)
    {
        $this->setRealHandler($this->controller->getActiveSubSection());
        $vars = $request->requestVars();
        // Ensure we only process saveable fields (non structural, readonly, or disabled)
        $allowedFields = array_keys($this->Fields()->saveableFields());

        // Populate the form
        $this->loadDataFrom($vars, true, $allowedFields);

        // Protection against CSRF attacks
        $token = $this->getSecurityToken();
        if (!$token->checkRequest($request)) {
            $securityID = $token->getName();
            if (empty($vars[$securityID])) {
                $this->httpError(400, _t("Form.CSRF_FAILED_MESSAGE",
                    "There seems to have been a technical problem. Please click the back button, " .
                    "refresh your browser, and try again."
                ));
            } else {
                // Clear invalid token on refresh
                $data = $this->getData();
                unset($data[$securityID]);
                Session::set("FormInfo.{$this->FormName()}.data", $data);
                Session::set("FormInfo.{$this->FormName()}.errors", array());
                $this->sessionMessage(
                    _t("Form.CSRF_EXPIRED_MESSAGE", "Your session has expired. Please re-submit the form."),
                    "warning"
                );
                return $this->controller->redirectBack();
            }
        }

        // Determine the action button clicked
        $funcName = null;
        foreach ($vars as $paramName => $paramVal) {
            if (substr($paramName, 0, 7) == 'action_') {
                // Break off querystring arguments included in the action
                if (strpos($paramName, '?') !== false) {
                    list($paramName, $paramVars) = explode('?', $paramName, 2);
                    $newRequestParams = array();
                    parse_str($paramVars, $newRequestParams);
                    $vars = array_merge((array)$vars, (array)$newRequestParams);
                }

                // Cleanup action_, _x and _y from image fields
                $funcName = preg_replace(array('/^action_/', '/_x$|_y$/'), '', $paramName);
                break;
            }
        }

        // If the action wasn't set, choose the default on the form.
        if (!isset($funcName) && $defaultAction = $this->defaultAction()) {
            $funcName = $defaultAction->actionName();
        }

        if (isset($funcName)) {
            Form::set_current_action($funcName);
            $this->setButtonClicked($funcName);
        }

        // Permission checks (first on controller, then falling back to form)
        if (
            // Ensure that the action is actually a button or method on the form,
            // and not just a method on the controller.
            $this->realHandler->hasMethod($funcName)
            && !$this->realHandler->checkAccessAction($funcName)
            // If a button exists, allow it on the controller
            // buttonClicked() validates that the action set above is valid
            && !$this->buttonClicked()
        ) {
            return $this->httpError(
                403,
                sprintf('Action "%s" not allowed on controller (Class: %s)', $funcName, get_class($this->realHandler))
            );
        }

        // Validate the form
        if (!$this->validate()) {
            return $this->getValidationErrorResponse();
        }


        // First, try a handler method on the controller (has been checked for allowed_actions above already)
        if ($this->realHandler->hasMethod($funcName)) {
            return $this->controller->handleSubmit($vars, $this, $request, $funcName);
            // Otherwise, try a handler method on the form object.
        } elseif ($field = $this->checkFieldsForAction($this->Fields(), $funcName)) {
            return $field->$funcName($vars, $this, $request);
        }

        return $this->httpError(404);
    }

    public function handleField($request)
    {
        $field = $this->Fields()->dataFieldByName($request->param('FieldName'));

        if ($field) {
            return $field;
        } else {
            // falling back to fieldByName, e.g. for getting tabs
            return $this->Fields()->fieldByName($request->param('FieldName'));
        }
    }

}