# Silverstripe FoxCommerce

## Setting up product attributes

There are two classes included in Foxcommerce that are never used directly but serve as base classes and for relationship
purposes. These are `FoxcommerceProductAttribute` and `FoxcommerceProductAttributeValue`.

Let's say we want a colour attribute
### ProductColourAttribute
```php
class ProductColourAttribute extends FoxcommerceProductAttribute
{
    
    private static $defaults = [
        'Title' => 'Colour'
    ];
    
    protected static $has_many = [
        'Values' => 'ProductColourAttributeValue'
    ];
}
```


##ProductColourAttributeValue
```php
class ProductColourAttributeValue extends FoxcommerceProductAttributeValue
{
    protected static $db = [
        'HexCode' => 'Varchar(6)'
    ];
    
    protected static $has_one = [
        'Attribute' => 'ProductColourAttribute'
    ];

}
```  