<?php

/**
 * Class FoxcommerceProductAttributeValueLink
 *
 * @property boolean IsComplete
 * @property int $VariantID
 * @property int $AttributeID
 * @property int $AttributeValueID
 *
 * @method FoxcommerceProductVariant Variant()
 * @method FoxcommerceProductAttribute Attribute()
 * @method FoxcommerceProductAttributeValue AttributeValue()
 */
class FoxcommerceProductVariantAttributeValueLink extends DataObject
{

    public function getTitle()
    {
        if (!$this->getIsComplete()) {
            return 'Broken Attribute Link';
        }

        return $this->Variant()->Title . ' ' . $this->Attribute()->Title . ' ' . $this->AttributeValue()->Title;
    }

    private static $has_one = [
        'Variant'        => 'FoxcommerceProductVariant',
        'Attribute'      => 'FoxcommerceProductAttribute',
        'AttributeValue' => 'FoxcommerceProductAttributeValue'
    ];

    private static $cart_summary = [
        'ID',
        'getAttributeTitle' => 'Attribute',
    ];

    private static $cart_summary_relations = [
        'AttributeValue' => 'Value'
    ];

    public function getIsComplete()
    {
        return ($this->VariantID && $this->AttributeID && $this->AttributeValueID);
    }

    public function getAttributeTitle()
    {
        return $this->Attribute()->Title;
    }

    public function getDescriptionx()
    {
        return ['label' => $this->Attribute()->Title, 'value' => $this->AttributeValue()];
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}