<?php

/**
 * Class FoxcommerceProduct_ProductVariantsExtension
 *
 * @property FoxcommerceProduct $owner
 */
class FoxcommerceProduct_ProductVariantsExtension extends SiteTreeExtension
{
    private static $has_many = [
        'Variants' => 'FoxcommerceProductVariant'
    ];

    public function updateCMSFields(FieldList $fields)
    {

        $attributeChangeMessage      = _t(
            'FoxcommerceProductVariant.AttributeChangeMessage',
            "When you add an attribute for a product you'll need to save before you can use it on a variation"
        );
        $attributeChangeMessageField = LiteralField::create(
            "AttributeChangeMessageHeader",
            "<p class=\"message warning\">{$attributeChangeMessage}</p>"
        );

        $config = new GridFieldConfig_RecordEditor();
        $config->addComponent(new GridFieldDuplicateButton(), 'GridFieldEditButton');

        $fields->addFieldsToTab('Root.Variations', [
            $attributeChangeMessageField,
            $fields->dataFieldByName('Attributes'),
            GridField::create("ProductVariantsGridField", "Variations", $this->owner->Variants(), $config)
        ]);

        $fields->removeByName('ProductAttributes');
    }

    public function updateCartSummary(&$summary)
    {
        unset($summary['Attributes']);
        $summary['Attributes'] = $this->getVariantAttributeMap();
        $summary['VariantAndAttributesIDMap'] = $this->getVariantAndAttributesIDMap();
        $summary['Variants']   = [];
        /** @var FoxcommerceProductVariant $variant */
        foreach ($this->owner->Variants()->filter(['IsEnabled' => true]) as $variant) {
            $summary['Variants'][$variant->ID] = FoxcommerceHelper::build_cart_summary($variant);
        }
    }

    public function getVariantAndAttributesIDMap(){
        $map = [];

        $this->owner->Variants()->filter(['IsEnabled' => true])->each(function(FoxcommerceProductVariant $variant) use(&$map){
            $data = [
                'VariantID' => $variant->ID,
                'Attributes' => []
            ];

            $variant->AttributeValues()->each(function (FoxcommerceProductVariantAttributeValueLink $attributeValue) use(&$data){
                $data['Attributes'][$attributeValue->AttributeID] = $attributeValue->AttributeValueID;
            });

            $map[] = $data;
        });

        return $map;

    }

    public function getVariantAttributeMap()
    {
        $attributes = [];

        $variantIDs = $this->owner->Variants()->filter(['IsEnabled' => true])->column('ID');

        /** @var FoxcommerceProductVariantAttributeValueLink[] $links */
        $links = FoxcommerceProductVariantAttributeValueLink::get()->filter(['VariantID' => $variantIDs]);


        foreach ($links as $attr) {
            $attrID  = $attr->AttributeID;
            $valueID = $attr->AttributeValueID;

            if (!isset($attributes[$attrID])) {
                $attributes[$attrID] = [
                    'Attribute' => FoxcommerceHelper::build_cart_summary($attr->Attribute()),
                    'Values'    => []
                ];
            }

            $attributes[$attrID]['Values'][$valueID] = FoxcommerceHelper::build_cart_summary($attr->AttributeValue());
        }

        return $attributes;
    }

}