<?php

class FoxcommerceOrder_ProductVariantsExtension extends Extension
{

    public function beforeUpdateOrderRequest(SS_HTTPRequest $request, FoxcommerceProduct $product)
    {
        if (!$variant = $product->Variants()->byID($request->requestVar('VariantID'))) {
            return 'Non matching "VariantID" parameter';
        }
    }

    public function beforeWriteOrderItem(SS_HTTPRequest $request, FoxcommerceOrderItem $orderItem)
    {
        $orderItem->VariantVersionID = $orderItem->Variant()->Version;
    }

    public function afterWriteOrderItem(SS_HTTPRequest $request, FoxcommerceOrderItem $orderItem){

        /** @var FoxcommerceProduct $product */
        $product = $orderItem->Product();

        /** @var FoxcommerceProductVariant $variant */
        $variant = $orderItem->Variant();

        /** @var FoxcommerceProductVariantAttributeValueLink $attributeValueLink */
        foreach ($variant->AttributeValues() as $attributeValueLink) {
            /** @var FoxcommerceOrderItemAttributeValueLink $orderItemAttributeValue */

            $attribute = $attributeValueLink->Attribute();
            $value     = $attributeValueLink->AttributeValue();

            $orderItemAttributeValue                          = FoxcommerceOrderItemAttributeValueLink::create();
            $orderItemAttributeValue->OrderItemID             = $orderItem->ID;
            $orderItemAttributeValue->AttributeID             = $attribute->ID;
            $orderItemAttributeValue->AttributeVersionID      = $attribute->Version;
            $orderItemAttributeValue->AttributeValueID        = $value->ID;
            $orderItemAttributeValue->AttributeValueVersionID = $value->Version;
            $orderItemAttributeValue->write();
        }
    }

}