<?php

class FoxcommerceOrderItem_ProductVariantsExtension extends DataExtension
{

    protected static $db = [
        'VariantVersionID' => 'Int'
    ];

    protected static $has_one = [
        'Variant' => 'FoxcommerceProductVariant'
    ];

    private static $cart_summary = [
        'VariantVersionID',
        'VariantID',
    ];

    private static $summary_fields = [
        'Variant.CMSCode'        => 'Variant Code',
        'Variant.Title'          => 'Variant Title',
        'Variant.AttributesList' => 'Variant Attributes',
    ];

    private static $cart_summary_relations = [
        'Variant',
    ];

    /**
     * @return FoxcommerceProductVariant
     */
    public function Variant()
    {
        return Versioned::get_version('FoxcommerceProductVariant', $this->owner->VariantID, $this->owner->VariantVersionID);
    }

}