<?php

/**
 * Class FoxcommerceProduct_TaxExtension
 *
 * @property FoxcommerceProduct|FoxcommerceProduct_TaxExtension $owner
 */
class FoxcommerceProduct_TaxExtension extends SiteTreeExtension
{

    public function updatePriceForCalculations(&$itemPrice)
    {
        $order = FoxcommerceOrder::current();
        $config = FoxcommerceConfig::current();
        if($config->displayTaxInclusive()){
            if($order->Country()->TaxRate()->exists()){
                $itemPrice = $order->Country()->TaxRate()->addTo($itemPrice);
            }
        }
    }

    public function getBaseItemPrice()
    {
        $config = FoxcommerceConfig::current();

        $basePrice = $this->owner->ItemPrice;

        if ($config->isTaxInclusive()) {
            /** @var FoxcommerceTaxRate $baseTaxRate */
            $baseTaxRate = $config->EntryTaxRate();

            return sprintf('%.2f', round($baseTaxRate->addTo($basePrice), 2));
        }

        return $basePrice;
    }

    public function updateCMSFields(FieldList $fields)
    {

        $taxStyle = FoxcommerceConfig::current()->TaxStyle;

        /** @var NumericField $ItemPriceField */
        $ItemPriceField = $fields->dataFieldByName('ItemPrice');
        $ItemPriceField->setName('BaseItemPrice');
        $ItemPriceField->setDescription(_t(
            'FoxcommerceProduct.ItemPriceTaxStyleMessage',
            'Enter the item price {tax_style} in your base currency ({base_currency})', [
                'base_currency' => FoxcommerceCurrency::baseCurrency()->Code,
                'tax_style'     => _t("FoxcommerceTaxRate.{$taxStyle}")
            ]
        ));
    }

    public function TaxCode()
    {
        $taxRate = FoxcommerceOrder::current()->Country()->TaxRate();
        if ($taxRate) return $taxRate->Code;
    }

    public function TaxType()
    {
        return FoxcommerceConfig::current()->TaxStyle;
    }

    public function onBeforeWrite()
    {

        if(in_array('BaseItemPrice', array_keys($this->owner->getQueriedDatabaseFields()))){
            $config = FoxcommerceConfig::current();

            $basePrice = $this->owner->getQueriedDatabaseFields()['BaseItemPrice'];

            if ($config->isTaxInclusive()) {
                /** @var FoxcommerceTaxRate $baseTaxRate */
                $baseTaxRate            = $config->EntryTaxRate();
                $this->owner->ItemPrice = $baseTaxRate->subtractFrom($basePrice);
            } else {
                $this->owner->ItemPrice = $basePrice;
            }
        }
    }

}