<?php

/**
 * Class FoxcommerceCountry_TaxExtension
 *
 * @property FoxcommerceCountry|FoxcommerceCountry_TaxExtension $owner
 * @property int $TaxRateID
 * @method FoxcommerceTaxRate TaxRate()
 */
class FoxcommerceCountry_TaxExtension extends DataExtension
{

    private static $has_one = [
        'TaxRate' => 'FoxcommerceTaxRate',
    ];

    private static $summary_fields = [
        'TaxRate.Description' => 'Tax Rate',
    ];
    
    private static $searchable_fields = [
        'TaxRateID' => ['title' => 'Tax Applied'],
    ];

    public function updateCMSFields(FieldList $fields)
    {
        $taxRates = FoxcommerceTaxRate::get('FoxcommerceTaxRate', ['Enabled' => true])->map()->toArray();

        if ($taxRates) {
            $fields->insertBefore('Enabled',
                DropdownField::create('TaxRateID', 'Tax Rate',
                    $taxRates)->setHasEmptyDefault(true)->setEmptyString('(none)')
            );
        }

        if ($this->owner->TaxRateID && !array_key_exists($this->owner->TaxRateID, $taxRates)) {
            $obsoleteWarning = _t(
                'FoxcommerceCountry.DisabledTaxRateWarning',
                "This country is linked to a tax rate that is no longer available. Saving will unlink this country from the tax rate."
            );
            $fields->insertBefore('Title', LiteralField::create("DisabledTaxRateWarningHeader",
                "<p class=\"message warning\">{$obsoleteWarning}</p>")
            );
        }

    }
}