<?php

/**
 * Class FoxcommerceConfiguration_AdminSection_TaxExtension
 *
 * @property FoxcommerceConfiguration_AdminSection $owner
 */
class FoxcommerceConfiguration_AdminSection_TaxExtension extends LeftAndMainExtension
{

    public function updateCMSFields(FieldList $fields)
    {
        $config    = FoxcommerceConfig::current();
        $taxStyles = ['Inclusive' => 'Inclusive', 'Exclusive' => 'Exclusive'];
        $taxRates  = FoxcommerceTaxRate::get()->map('ID', 'Description')->toArray();

        $fields->addFieldsToTab('Root.Main', [
            DropdownField::create('DisplayTaxStyle', 'Display Tax style', $taxStyles, $config->DisplayTaxStyle)
                ->setDescription(_t('FoxcommerceTaxRate.DisplayTaxStyleMessage')),
            DropdownField::create('TaxStyle', 'Entry Tax style', $taxStyles, $config->TaxStyle)
                ->setDescription(_t('FoxcommerceTaxRate.EntryTaxStyleMessage')),
            $entryTaxRateField = DropdownField::create('EntryTaxRateID', 'Entry Tax Rate', $taxRates, $config->EntryTaxRateID)
                ->setDescription(_t('FoxcommerceTaxRate.EntryTaxRateMessage'))
        ]);

        $entryTaxRateField->displayIf('TaxStyle')->isEqualTo('Inclusive')->end();
        $entryTaxRateField->setEmptyString('(none)');
    }

}