<?php

/**
 * Class FoxcommerceConfig_TaxExtension
 *
 * @property FoxcommerceConfig|FoxcommerceConfig_TaxExtension $owner
 * @property string                                           $TaxStyle
 */
class FoxcommerceConfig_TaxExtension extends DataExtension
{
    protected static $db = [
        'TaxStyle'        => 'Enum("Inclusive,Exclusive", "Inclusive")',
        'DisplayTaxStyle' => 'Enum("Inclusive,Exclusive", "Inclusive")'
    ];

    protected static $has_one = [
        'EntryTaxRate' => 'FoxcommerceTaxRate'
    ];

    public function isTaxInclusive()
    {
        return $this->owner->TaxStyle === 'Inclusive';
    }

    public function isTaxExclusive()
    {
        return $this->owner->TaxStyle === 'Exclusive';
    }

    public function displayTaxInclusive()
    {
        return $this->owner->DisplayTaxStyle === 'Inclusive';
    }

    public function displayTaxExclusive()
    {
        return $this->owner->DisplayTaxStyle === 'Exclusive';
    }

    public function onBeforeWrite()
    {
        if ($this->owner->isTaxExclusive()) {
            $this->owner->EntryTaxRateID = null;
        }
    }


}