<?php

class GlobalContentExtension extends DataExtension
{

	protected static $db = [
		'Email'      => 'Varchar(255)',
		'GooglePlus' => 'Varchar(255)',
		'Twitter'    => 'Varchar(255)',
		'Skype'      => 'Varchar(255)',
		'Facebook'   => 'Varchar(255)',
		'YouTube'    => 'Varchar(255)',
		'LinkedIn'   => 'Varchar(255)',
	];

	protected static $has_one = [
		'Logo'         => 'Image',
		'FallbackHero' => 'Image',
		'Favicon'      => 'Image'
	];

	public function updateCMSFields(FieldList $fields)
	{

		$fields->addFieldsToTab('Root.Main', [
			TextField::create('Email', 'Email Address')->setAttribute('placeholder', 'example john@example.com'),
			UploadField::create('Logo', 'Logo'),
			UploadField::create('Favicon', 'Favicon')
		]);

		$fields->addFieldsToTab('Root.SocialMedia', [
			TextField::create('GooglePlus', 'Google Plus')->setAttribute('placeholder', 'https://...'),
			TextField::create('Twitter', 'Twitter')->setAttribute('placeholder', 'https://...'),
			TextField::create('Skype', 'Skype')->setAttribute('placeholder', 'https://...'),
			TextField::create('Facebook', 'Facebook')->setAttribute('placeholder', 'https://...'),
			TextField::create('YouTube', 'YouTube')->setAttribute('placeholder', 'https://...'),
			TextField::create('LinkedIn', 'LinkedIns')->setAttribute('placeholder', 'https://...')
		]);

		$showFallbackHero = $this->owner->config()->get('show_fallback_hero');

		$fields->removeByName('FallbackHero');

		if ($showFallbackHero) {
			$fields->insertAfter('Logo', UploadField::create('FallbackHero', 'Fallback Header Image'));
		}

	}

}
