<?php

/**
 * Base page type
 */
class Page extends SiteTree {

    /**
     * Additional fields which are available to all pages
     * @var array
     */
    private static $db = [
    ];

    /**
     * One to one relations
     * @var array
     */
    private static $has_one = [];

    /**
     * One to many relations
     * @var array
     */

    private static $has_many = [
        'ContentBlocks' => 'ContentBlock',
    ];

    public function getCMSFields() {

        $this->beforeUpdateCMSFields(function (FieldList $fields) {
            $ContentBlocksConfig = GridFieldConfig_RecordEditor::create();

            $ContentBlocksConfig->removeComponentsByType("GridFieldAddNewButton");
            $ContentBlocksConfig->addComponent($multiClass = new GridFieldAddNewMultiClass());
            $ContentBlocksConfig->addComponent(new GridFieldOrderableRows('SortOrder'));
            $grid    = GridField::create("ContentBlocks", "Content Blocks", $this->ContentBlocks(), $ContentBlocksConfig);
            $multiClass->setTitle('Add New Content Block');
            $classes = $multiClass->getClasses($grid);
            unset($classes['ContentBlock']);
            $multiClass->setClasses($classes);

            $fields->addFieldToTab('Root.ContentBlocks', $grid);
        });

        $fields = parent::getCMSFields();

        Requirements::customCSS(
            <<<CSS
			.htmleditor label.left {
				width: 100%;
			}
CSS
        );

        return $fields;
    }

    /**
     * Validation which is applied to all pages
     * @return RequiredFields
     */
    public function getCMSValidator() {
        return new RequiredFields(
            []
        );
    }

    public function getDisplayedContentBlocks() {
        return $this->ContentBlocks()->filter('Displayed', true);
    }

    public function getHasContentBlocks() {
        return $this->getDisplayedContentBlocks()->Count() > 0;
    }

    /**
     * Returns the site default meta tags
     * This overload also checks if the domain contains one of our non-indexable domains
     * If it does it adds the noindex meta tag.
     *
     * @param bool $includeTitle
     *
     * @return string
     */
    public function MetaTags($includeTitle = true) {
        $tags          = parent::MetaTags($includeTitle);
        $domains       = Config::inst()->get('Development', 'NoIndexDomains');
        $currentDomain = strtolower(Director::protocolAndHost());
        if (is_array($domains) && !empty($domains)) {
            foreach ($domains as $nonIndexableDomain) {
                if (strpos($currentDomain, strtolower($nonIndexableDomain)) !== false) {
                    return $tags . '<meta name="robots" content="noindex">';
                }
            }
        }

        return $tags;
    }

}

/**
 * Base page controller
 */
class Page_Controller extends ContentController {
}