var config = {
	// Source Config
	src_main_js: ['app.jsx'],
	src_images: './src/images/',
	src_javascripts: './src/javascript/',
	src_stylesheets: './src/less/',
	// Vendors
	vend_main_css: 'vendor.css',
	vend_main_js: 'vendor.js',
	vend_main_cdn_js: 'vendor-cdn.js',
	// Destination Config
	dist_fonts: './public/fonts/',
	dist_images: './public/images/',
	dist_javascripts: './public/javascript/',
	dist_stylesheets: './public/css/',
	// Theme Config
	theme: './src/theme/',
	// Vendor Config
	bower: './bower_components/',
	plugins: './src/plugins/',
	// Auto Prefixer
	autoprefix: 'last 3 version',
	// Environment
	environment: 'dev'
};

var files = {
	src_fonts: [
		'./src/fonts/**/*',
		config.bower + '/font-awesome/fonts/**/*',
		config.bower + '/devicons/fonts/**/*',
		config.bower + '/bootstrap/fonts/**/*',
		config.bower + '/lightgallery/dist/fonts/**/*',
		config.plugins + '/slider-revolution/examples&source/rs-plugin/font/**/*'
	],
	vend_stylesheets: [
		config.bower + '/font-awesome/css/font-awesome.css',
		config.bower + '/devicons/css/devicons.css',
		config.bower + '/lightgallery/dist/css/lightgallery.css',
		config.bower + '/lightgallery/dist/css/lg-transitions.css',
		config.plugins + '/animations/animations.css',
		config.bower + '/animate.css/animate.css',
		config.plugins + '/slider-revolution/examples&source/rs-plugin/css/settings.css',
		config.plugins + '/cubeportfolio-jquery-plugin/cubeportfolio/css/cubeportfolio.css',
		config.bower + '/OwlCarousel/owl-carousel/owl.carousel.css'
	],
	vend_javascripts: [
		config.bower + '/jquery/dist/jquery.js',
		// config.bower + '/jquery-ui/ui/*.js',
		config.bower + '/lightgallery/dist/js/lightgallery-all.js',
		config.bower + '/bootstrap/dist/js/bootstrap.js',
		config.bower + '/Modernizr/modernizr.js',
		config.bower + '/picturefill/dist/picturefill.js',
		config.bower + '/smoothscroll-for-websites/SmoothScroll.js',
		config.bower + '/wow/dist/wow.js',
		config.bower + '/classie/classie.js',
		config.bower + '/jQuery-One-Page-Nav/jquery.nav.js',
		config.bower + '/jquery.stellar/jquery.stellar.js',
		config.plugins + '/slider-revolution/examples&source/rs-plugin/js/jquery.themepunch.tools.min.js',
		config.plugins + '/slider-revolution/examples&source/rs-plugin/js/jquery.themepunch.revolution.min.js',
		config.bower + '/OwlCarousel/owl-carousel/owl.carousel.js',
		config.bower + '/jquery-knob/js/jquery.knob.js',
		config.bower + '/DialogEffects/js/dialogFx.js',
		config.plugins + '/cubeportfolio-jquery-plugin/cubeportfolio/js/jquery.cubeportfolio.js',
		config.bower + '/JSCSSP/cssParser.js',
		config.bower + '/gmaps/gmaps.js'
	]
};

var clean_paths = [config.dist_fonts, config.dist_images, config.dist_javascripts, config.dist_stylesheets];

config.files = files;
config.clean_paths = clean_paths;

var shim = {};

Object.keys(config.files.vend_javascripts).forEach(function (key) {
	shim[config.files.vend_javascripts[key]] = key;
});

config.files.vend_javascripts = shim;

module.exports = config;
