var ScreenShotGenerator = function (nightmare) {
    this.nightmare = nightmare;
    this.dimensions = {
        width: null,
        height: null
    };
};

ScreenShotGenerator.prototype = {
    setFilePath: function (filePath) {
        this.filePath = filePath || this.filePath;
        return this;
    },
    setDimensions: function (dimensions) {
        this.dimensions.width = dimensions.width || this.dimensions.width;
        this.dimensions.height = dimensions.height || this.dimensions.height;
        return this;
    },
    generate: function (dimensions) {
        this.setDimensions(dimensions || {});
        var lim    = 8190;
        var chunks = [0];
        if (this.dimensions.height > lim) {
            this.nightmare
                .viewport((this.dimensions.width + 25), 8215)
                .wait(1000);
            var points = this.dimensions.height / lim;
            for (var i = 1; i < points; i++) {
                chunks.push((i + 1) * lim);
            }
        } else {
            this.nightmare
                .viewport(this.dimensions.width, this.dimensions.height)
                .wait(1000);
        }
        for (var index in chunks) {
            var chunk = chunks[index];
            var filePath = this.filePath.split('.');
            if (chunks.length > 1) {
                var extension = filePath.pop();
                filePath = filePath.join('.') + '-' + index + '.' + extension;
            } else {
                filePath = filePath.join('.');
            }
            this.nightmare
                .scrollTo(chunk, 0)
                .wait(100)
                .screenshot(filePath);
        }
        return this.nightmare;
    }
};