$(document).ready(function() {
    function invertCssColor(color) {
        console.log(color);
        if (color.indexOf("#") >= 0) {
            var rgb = invertColor(hexColor2rgb(color));
        } else {
            var rgb = invertColor(rbgColor2obj(color))
        }
        console.log(rgb);
        return rgb2hexColor(rgb);
    }

    function invertColor(rgb) {
        var yuv = rgb2yuv(rgb);
        var factor = 120;
        var threshold = 100;
        yuv.y = clamp(yuv.y + (yuv.y > threshold ? -factor : factor));
        return yuv2rgb(yuv);
    }

    function rbgColor2obj(color) {
        var obj = color.match(/rgb\((.*), ?(.*), ?(.*)\)/);
        console.log(obj);
        return {
            r: obj[1],
            g: obj[2],
            b: obj[3]
        };
    }

    function hexColor2rgb(color) {
        color = color.substring(1); // remove #
        return {
            r: parseInt(color.substring(0, 2), 16),
            g: parseInt(color.substring(2, 4), 16),
            b: parseInt(color.substring(4, 6), 16)
        };
    }

    function rgb2hexColor(rgb) {
        return '#' + dec2hex(rgb.r) + dec2hex(rgb.g) + dec2hex(rgb.b);
    }

    function dec2hex(n) {
        var hex = n.toString(16);
        if (hex.length < 2) {
            return '0' + hex;
        }
        return hex;
    }

    function rgb2yuv(rgb){
        var y = clamp(rgb.r *  0.29900 + rgb.g *  0.587   + rgb.b * 0.114);
        var u = clamp(rgb.r * -0.16874 + rgb.g * -0.33126 + rgb.b * 0.50000 + 128);
        var v = clamp(rgb.r *  0.50000 + rgb.g * -0.41869 + rgb.b * -0.08131 + 128);
        return {y:y, u:u, v:v};
    }

    function yuv2rgb(yuv){
        var y = yuv.y;
        var u = yuv.u;
        var v = yuv.v;
        var r = clamp(y + (v - 128) *  1.40200);
        var g = clamp(y + (u - 128) * -0.34414 + (v - 128) * -0.71414);
        var b = clamp(y + (u - 128) *  1.77200);
        return {r:r,g:g,b:b};
    }

    function clamp(n){
        if (n<0) { return 0;}
        if (n>255) { return 255;}
        return Math.floor(n);
    }


    $('[data-hook="bg"]').each(function() {
        var c1 = $(this).css("background-color");
        console.log(c1);
        var c2 = invertCssColor(c1);
        $(this).css({"color": c2});
    });
});