$(function () {
    $('[data-hook="static-form"]').on('submit', function (e) {

        var $form = $(this);
        var $container = $form.closest('.container');
        var data = $form.serialize();

        $.ajax({
            type: 'POST',
            url: $form.attr('action'),
            data: data,
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    $form.replaceWith('<div class="text-block">' + response.message + '</div>');
                    $('html, body').animate({
                        scrollTop: $container.offset().top - 100
                    }, 10);
                } else {
                    $.each(response.errors, function (index, err) {
                        $form.find('[name="' + err.fieldName + '"]').after('<div class="alert alert-danger text-left" role="alert">' + err.message + '</div>');
                    });
                }
            }
        });

        e.preventDefault();
        return false;
    });
});