<% if $PortfolioItems.Count > 0 %>
    <section class="spaced sm-y" <% if $ShowInMenu %>data-block="{$ID}"<% end_if %>>
        <div class="container">
            <% if $Title %>
                <div class="row">
                    <div class="col-sm-12">
                        <h4 class="text-center">{$Title}</h4>
                        <div class="spacer-15"></div>
                    </div>
                </div>
            <% end_if %>
            <% if $PortfolioCategories.Count > 0 %>
                <div class="row">
                    <ul class="container-filter categories-filter">
                        <li><a class="categories active" data-filter="*">All</a></li>
                        <% loop $PortfolioCategories %>
                            <li><a class="categories" data-filter=".portfolio-cat-{$ID}">{$Title}</a></li>
                        <% end_loop %>
                    </ul>
                </div>
            <% end_if %>
            <div class="row container-grid nf-col-3" data-hook="gallery">
                <% loop $PortfolioItems %>
                    <div class="nf-item spacing <% loop $PortfolioCategories %>portfolio-cat-{$ID} <% end_loop %>">
                        <div class="item-box">
                            <div class="light-gallery-item" data-src="{$Image.Url}" data-sub-html=".caption">
                                <img alt="{$Image.AltText}" src="{$Image.CroppedImage(400,260).Url}" class="item-container">
                                <div class="item-mask">
                                    <div class="item-caption">
                                        <h5 class="white">{$Title} <% if $SubTitle %>- {$SubTitle}<% end_if %></h5>
                                        <p class="white caption">{$Caption}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <% end_loop %>
            </div>
        </div>
    </section>
<% end_if %>
