var config = {
    // Source Config
    src_main_js:      ['app.jsx'],
    src_images:       './src/images/',
    src_javascripts:  './src/javascript/',
    src_stylesheets:  './src/styles/',
    src_stylesheets_less:  './src/styles/less/',
    src_stylesheets_scss:  './src/styles/scss/',
    // Vendors
    prod_main_css:    'app.css',
    vend_main_css:    'vendor.css',
    vend_main_js:     'vendor.js',
    vend_main_cdn_js: 'vendor-cdn.js',
    // Destination Config
    dist_fonts:       './public/fonts/',
    dist_images:      './public/images/',
    dist_javascripts: './public/javascript/',
    dist_stylesheets: './public/css/',
    // Theme Config
    theme:            './src/theme/',
    // Vendor Config
    bower:            './bower_components/',
    plugins:          './src/plugins/',
    // Auto Prefixer
    autoprefix:       'last 3 version',
    // Environment
    environment:      'dev'
};

var files = {
    src_fonts: [
        './src/fonts/**/*',
        config.bower + '/font-awesome/fonts/**/*',
        config.bower + '/open-iconic/font/fonts/**/*',
        config.bower + '/Ionicons/fonts/**/*',
        config.bower + '/lightgallery/dist/fonts/**/*'
    ],
    vend_stylesheets: [
        config.bower + '/flexslider/flexslider.css',
        config.bower + '/OwlCarousel/owl-carousel/owl.carousel.css',
        config.bower + '/mediaelement/build/mediaelementplayer.css',
        config.bower + '/Tipper/jquery.fs.tipper.css',
        config.theme + '/css/colorbox.css',
        config.theme + '/css/style.css',
        config.theme + '/css/sidebar-menu.css',
        config.theme + '/css/jquery-ui.css',
        config.bower + '/font-awesome/css/font-awesome.css',
        config.bower + '/Ionicons/css/ionicons.css',
        config.bower + '/animate.css/animate.css',
        config.bower + '/lightgallery/dist/css/lightgallery.css',
        config.bower + '/lightgallery/dist/css/lg-transitions.css'
    ],
    vend_javascripts: {
        jquery: config.bower + '/jquery/dist/jquery.js',
        easing: config.bower + '/jquery.easing/jquery.easing.js',
        ui: config.theme + '/js/jquery-ui.min.js',
        foundation: config.bower + '/bootstrap-sass/assets/javascripts/bootstrap.js',
        flex: config.bower + '/flexslider/jquery.flexslider.js',
        vids: config.bower + '/jquery.fitvids/jquery.fitvids.js',
        viewport: config.bower + '/jQuery-viewport-checker/src/jquery.viewportchecker.js',
        stellar: config.bower + '/jquery.stellar/jquery.stellar.js',
        wow: config.bower + '/wow/dist/wow.js',
        colorbox: config.bower + '/jquery-colorbox/jquery.colorbox.js',
        carousel: config.bower + '/OwlCarousel/owl-carousel/owl.carousel.js',
        isotope: config.bower + '/isotope/dist/isotope.pkgd.js',
        masonry: config.bower + '/masonry/dist/masonry.pkgd.js',
        images: config.bower + '/imagesloaded/imagesloaded.pkgd.js',
        sidebar: config.theme + '/js/sidebar-menu.js',
        tipper: config.bower + '/Tipper/jquery.fs.tipper.js',
        media: config.bower + '/mediaelement/build/mediaelement-and-player.js',
        theme: config.theme + '/js/theme.js',
        navigation: config.theme + '/js/navigation.js',
        gallery: config.bower + '/lightgallery/dist/js/lightgallery.js',
        autoplay: config.bower + '/lg-autoplay/dist/lg-autoplay.js',
        fullscren: config.bower + '/lg-fullscreen/dist/lg-fullscreen.js',
        hash: config.bower + '/lg-hash/dist/lg-hash.js',
        pager: config.bower + '/lg-pager/dist/lg-pager.js',
        share: config.bower + '/lg-share/dist/lg-share.js',
        thumbnail: config.bower + '/lg-thumbnail/dist/lg-thumbnail.js',
        video: config.bower + '/lg-video/dist/lg-video.js',
        zoom: config.bower + '/lg-zoom/dist/lg-zoom.js'
    }
};

var clean_paths = [config.dist_fonts, config.dist_images, config.dist_javascripts, config.dist_stylesheets];

config.files       = files;
config.clean_paths = clean_paths;

var shim = {};

Object.keys(config.files.vend_javascripts).forEach(function (key) {
    shim[config.files.vend_javascripts[key]] = key;
});

config.files.vend_javascripts = shim;

module.exports = config;
