const config = require('../config');

const gulp = require('gulp'),
    path = require('path'),
    concat = require('gulp-concat'),
    less = require('gulp-less'),
    sass = require('gulp-sass'),
    autoprefixer = require('gulp-autoprefixer'),
    minify = require('gulp-cssnano'),
    merge = require('merge-stream');

module.exports = function () {



    let less$ = gulp.src(path.join(config.src_stylesheets_less, 'app.less'))
        .pipe(less({
            paths: [config.bower]
        }))
        .pipe(autoprefixer({browsers: config.autoprefix}));

    let scss$ = gulp.src(path.join(config.src_stylesheets_scss, 'app.scss'))
        .pipe(sass({
            outputStyle:     'expanded',
            precision:       10,
            includePaths: config.bower,
            errLogToConsole: true
        }))
        .pipe(autoprefixer({browsers: config.autoprefix}));

    let pipe = merge(less$, scss$);

    if (config.environment === 'prod') {
        pipe.pipe(minify({safe: true, discardDuplicates: false, verbose: true}))
    }

    pipe.pipe(concat(config.prod_main_css))
        .pipe(gulp.dest(config.dist_stylesheets));

    return pipe;
};
