import React from 'react';


$(function () {
  console.log('Hello');
});

$(function () {
  var $gallery = $('[data-hook="gallery"]');
  if ($gallery.length) {
    $gallery.lightGallery({
      selector: '.gallery-item',
    });
  }
});

$(function () {
  var $profileMaps = $('[data-hook="map"]');

  if ($profileMaps.length) {
    $profileMaps.each(function () {

      var map;
      var $profileMap = $(this);

      var address = $profileMap.data('address');
      var zoom = parseInt($profileMap.data('zoom'));
      var type = $profileMap.data('type');
      var mContent = $profileMap.data('content');

      map = new GMaps({
        el: this,
        lat: 0,
        lng: 0,
        zoom: zoom,
        mapType: type,
        scrollwheel: false,
        draggable: true,
        styles: [{'featureType': 'administrative', 'stylers': [{'visibility': 'off'}]}, {
          'featureType': 'poi',
          'stylers': [{'visibility': 'simplified'}],
        }, {'featureType': 'road', 'stylers': [{'visibility': 'simplified'}]}, {
          'featureType': 'water',
          'stylers': [{'visibility': 'simplified'}],
        }, {'featureType': 'transit', 'stylers': [{'visibility': 'simplified'}]}, {
          'featureType': 'landscape',
          'stylers': [{'visibility': 'simplified'}],
        }, {'featureType': 'road.highway', 'stylers': [{'visibility': 'off'}]}, {
          'featureType': 'road.local',
          'stylers': [{'visibility': 'on'}],
        }, {
          'featureType': 'road.highway',
          'elementType': 'geometry',
          'stylers': [{'visibility': 'on'}],
        }, {
          'featureType': 'water',
          'stylers': [{'color': '#84afa3'}, {'lightness': 52}],
        }, {'stylers': [{'saturation': -77}]}, {'featureType': 'road'}],
      });


      GMaps.geocode({
        address: address,
        callback: function (results, status) {
          if (status == 'OK') {
            var coordinates = results[0].geometry.location;
            let lat = coordinates.lat();
            let lng = coordinates.lng();
            map.setCenter(lat, lng);
            map.addMarker({
              lat: lat,
              lng: lng,
              title: address,
              infoWindow: {
                content: mContent,
              },
            });

          }
        },
      });
    });
  }
});

$(function () {

  const videos = $('[data-thumbnails]');

  videos.on('click', function (evt) {

    const thumbnail = evt.target || evt.srcElement;
    const thumbnailTitle = $(this).children('p');
    const videoTitle = thumbnail.dataset.videoTitle;
    const videoId = thumbnail.dataset.videoId;

    const videoPlayer = $('[data-video-player]').children()[0];
    const videoPlayerTitle = $('[data-main-title]');

    const currentVideoId = videoPlayer.dataset.currentVideoId;
    const currentVideoTitle = videoPlayer.dataset.currentVideoTitle;

    videoPlayer.src = `https://www.youtube.com/embed/${videoId}?autoplay=0&rel=0`;
    videoPlayer.dataset.currentVideoId = videoId;
    videoPlayer.dataset.currentVideoTitle = videoTitle;
    videoPlayerTitle.html(videoTitle);

    thumbnail.src = `https://img.youtube.com/vi/${currentVideoId}/hqdefault.jpg`;
    thumbnail.dataset.videoId = currentVideoId;
    thumbnail.dataset.videoTitle = currentVideoTitle;
    thumbnailTitle.html(currentVideoTitle);
  });
});