<% if $ShowInMenu %>
    <span class="breakPoint" id="content-block-{$ID}"></span>
<% end_if %>
<% if $PortfolioItems.Count > 0 %>
    <div class="section-xlg {$Background}">
        <div class="container">
            <% if $Title %>
                <div class="row">
                    <div class="col-sm-12">
                        <h2 class="block-header">
                            <span>{$Title}</span>
                        </h2>
                    </div>
                </div>
            <% end_if %>
            <% if $PortfolioCategories %>
                <div class="row">
                    <div class="col-sm-12">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs gallery__nav" role="tablist">
                            <li role="presentation" class="active">
                                <a href="#" role="tab" data-toggle="tab" data-filter="*">
                                    All
                                </a>
                            </li>

                            <% loop $PortfolioCategories %>
                                <li role="presentation">
                                    <a href="#" role="tab" data-toggle="tab" data-filter=".category_{$ID}">
                                        <span class="hidden-xs">{$Title}</span>
                                    </a>
                                </li>
                            <% end_loop %>
                        </ul>

                    </div>
                </div>
            <% end_if %>

            <div class="row isotope-container" data-hook="gallery">
                <% loop $PortfolioItems %>
                    <div class="col-sm-4 col-lg-3 isotope-item <% if $Link %> <% else %>gallery-item<% end_if %> <% loop $PortfolioCategories %>category_{$ID} <% end_loop %>"
                         data-src="{$Image.Url}">

                        <a href="{$Link.LinkUrl}">
                            <div class="thumbnail alt light-gallery-item">
                                <img src="{$Image.CroppedImage(240,160).Url}" alt="{$Image.AltText}">
                                <div class="caption">
                                    <h5>{$Title}</h5>
                                    <p>
                                        {$Caption}
                                    </p>
                                </div>
                            </div>
                        </a>

                    </div>
                <% end_loop %>

            </div> <!-- / .row -->
        </div> <!-- / .container -->
    </div>
<% end_if %>
