require('mocha-generators').install();

var Nightmare = require('nightmare');
var expect    = require('chai').expect;



describe('Test account form', function () {

    this.timeout(20000);

    it('should update account information correctly', function * () {

        // var screens = [[320, 'mobile'], [768, 'tab-p'], [1024, 'tab-l'], [1200, 'desk']];

        var nightmare = Nightmare({
            show:     false,
            width:    320,
            height:   100,
            switches: {
                'disable-http-cache':        true,
                'ignore-certificate-errors': true
            }
        });

        function getScrollHeight() {
            var body = document.querySelector('body');
            return {
                width:  body.scrollWidth + 25,
                height: body.scrollHeight + 25 // Buffer to add back on what electron removes

            }
        }

        var screenShotGenerator = new ScreenShotGenerator(nightmare);
        screenShotGenerator.setFilePath('./image/details/1-form.jpg');

        yield nightmare
            .goto('https://wam.freeparking.dev/')
            .wait('form[action*="login"]')
            .type('#username', 'webfox')
            .type('#password', 't35tf0x')
            .click('.btn-theme-primary')
            .wait('a[href*="tickets"]')
            .click('a[href*="mydetails"]')
            .wait('#detailsform')
            .evaluate(getScrollHeight)
            .then(function(dimensions){
                screenShotGenerator.generate(dimensions);
                return nightmare;
            });

        var link = yield nightmare
            .evaluate(function () {
                return window.location.href;
            });

        yield nightmare.end();

        expect(link).to.equal('https://wam.freeparking.dev/mydetails');
    });
});