var config = {
    // Source Config
    src_main_js:      ['app.jsx'],
    src_images: './src/images/',                       // Source Images Directory
    src_javascripts: './src/javascript/',                   // Source Javascripts Directory
    src_stylesheets: './src/less/',                         // Source Styles Sheets Directory
    // Vendors
    vend_main_css:    'vendor.css',
    vend_main_js:     'vendor.js',
    vend_main_cdn_js: 'vendor-cdn.js',
    // Destination Config
    dist_fonts:       './public/fonts/',                            // Destination Fonts Directory
    dist_images:      './public/images/',                           // Destination Images Directory
    dist_javascripts: './public/javascript/',                       // Destination Javascripts Directory
    dist_stylesheets: './public/css/',                              // Destination Styles Sheets Directory
    // Theme Config
    theme:            './src/theme/',
    // Bower Config
    bower: './bower_components/',                 // Bower Components
    plugins: './src/plugins/',                 // Bower Components
    // Auto Prefixer
    autoprefix: 'last 3 version',                      // Number of version Auto Prefixer to use
    // Server
    host: 'demo.dev',                           // Webserverhost
    port: 80                                   // Webserver port
};

var files = {
    src_fonts: [
        './src/fonts/**/*',
        config.bower + '/font-awesome/fonts/**/*',
        config.bower + '/bootstrap/fonts/**/*',
        config.bower + '/lightgallery/dist/fonts/**/*'
    ],
    vend_stylesheets: [
        config.bower + '/font-awesome/css/font-awesome.css',
        config.bower + '/lightgallery/dist/css/lightgallery.css',
        config.bower + '/lightgallery/dist/css/lg-transitions.css',
        config.theme + '/css/styles.css'
    ],
    vend_javascripts: [
        config.bower + '/jquery/dist/jquery.js',
        config.bower + '/jquery-migrate/src/migrate.js',
        config.bower + '/bootstrap/dist/js/bootstrap.js',
        config.bower + '/lightgallery/dist/js/lightgallery-all.js',
        config.bower + '/gmaps/gmaps.js',
        config.plugins + '/isotope/isotope.pkgd.min.js',
        config.plugins + '/isotope/imagesloaded.pkgd.min.js',
        config.plugins + '/scrolltopcontrol/scrolltopcontrol.js',
        config.theme + '/js/custom.js'
    ]
};


var clean_paths = [config.dist_fonts, config.dist_images, config.dist_javascripts, config.dist_stylesheets];

config.files       = files;
config.clean_paths = clean_paths;

var shim = {};

Object.keys(config.files.vend_javascripts).forEach(function (key) {
    shim[config.files.vend_javascripts[key]] = key;
});

config.files.vend_javascripts = shim;

module.exports = config;
