<?php

class SegmentContentBlock extends ContentBlock
{

    protected static $singular_name = 'Segments Section';
    protected static $plural_name   = 'Segments Sections';

    private static $has_many = [
        'Segments' => 'Segment',
    ];

    public function getCMSFields()
    {
        $this->beforeUpdateCMSFields(function(FieldList $fields) {
            $GridFieldConfig = new GridFieldConfig_RecordEditor();
            $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
            $GridField = new GridField("CarouselGridField", "Segments", $this->Segments(), $GridFieldConfig);

            $fields->addFieldToTab("Root.Main", $GridField);
        });

        $fields = parent::getCMSFields();

        $fields->removeByName('Segments');

        return $fields;
    }
}
