<?php

class Segment extends DataObject
{

    private static $extensions = [
        'GenericItemExtension' 
    ];

    protected static $db = [
        'Title' => 'Varchar(255)',
        'Content'     => 'Text',
    ];

    protected static $has_one = [
        'ContentBlock' => 'SegmentContentBlock',
    ];

    public function getCMSFields()
    {
        $fields = FieldList::create()->build([
            TextField::create('Title', 'Title'),
            TextareaField::create('Content', 'Content'),
        ]);

        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
